@extends('admin.layouts.master')

@section('content')

    <h3 class="page-title">
        Sub Categories
        <small>Manage Sub Categories</small>
    </h3>

    <div class="page-bar">
        <ul class="page-breadcrumb">

            <li>
                <a href="/admin">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="/admin/sub_categories">Sub Categories</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="/admin/sub_categories/create">Create</a>
            </li>

        </ul>
    </div>

    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN PORTLET-->
            <div class="portlet box green-meadow">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-puzzle"></i>Create New Sub Category
                    </div>
                    <div class="tools">
                        <a href="javascript:;" class="collapse">
                        </a>
                    </div>
                </div>

                <div class="portlet-body form">


                    <form action="/admin/sub_categories/create" id="form-username" method="post"
                          class="form-horizontal form-bordered">

                        <div class="form-group">
                            <label class="col-sm-3 control-label"></label>

                            <div class="col-sm-4">
                                @include('admin.layouts.notify')
                            </div>
                        </div>

                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>

                        <div class="form-group">
                            <label for="title" class="col-sm-3 control-label">Title</label>

                            <div class="col-sm-8">
                                <input id="title" class="form-control" type="text" name="title"
                                       placeholder="Enter Category title" value="{{old('title')}}"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="priority" class="col-sm-3 control-label">Priority</label>

                            <div class="col-sm-8">
                                <input id="priority" class="form-control" type="number" name="priority"
                                       placeholder="Enter Category priority" value="{{old('priority',1)}}"/>
                            </div>
                        </div>

                        {{--<div class="form-group">--}}
                            {{--<label for="scroll_type" class="col-sm-3 control-label">Scroll Type</label>--}}

                            {{--<div class="col-sm-8">--}}
                                {{--<div class="radio-list">--}}
                                    {{--<label class="radio-inline">--}}
                                        {{--<input type="radio" name="scroll_type" id="scroll_type"--}}
                                               {{--value="{{\App\Categories::SCROLL_TYPE_PAGINATION}}">--}}
                                        {{--Pagination--}}
                                    {{--</label>--}}
                                    {{--<label class="radio-inline">--}}
                                        {{--<input type="radio" name="scroll_type" id="scroll_type"--}}
                                               {{--value="{{\App\Categories::SCROLL_TYPE_SCROLL}}">--}}
                                        {{--Infinite Scroll--}}
                                    {{--</label>--}}
                                {{--</div>--}}
                            {{--</div>--}}
                        {{--</div>--}}

                        <div class="form-group">
                            <label for="parent_category" class="col-sm-3 control-label">Category</label>

                            <div class="col-sm-8">
                                <select id="parent_category" class="form-control" name="parent_category">
                                    @foreach($parent_categories as $cat)
                                        <option value="{{$cat->id}}">{{$cat->title}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="form-group">

                            <div class="col-md-offset-3 col-md-8">
                                <div class="checkbox">
                                    <label>
                                        <input name="show_in_menu" type="checkbox"> Show Category in Menu </label>
                                </div>
                            </div>

                        </div>

                        <div class="form-group">

                            <div class="col-md-offset-3 col-md-8">
                                <div class="checkbox">
                                    <label>
                                        <input name="show_in_sidebar" type="checkbox"> Show Category in Sidebar </label>
                                </div>
                            </div>

                        </div>

                        <div class="form-group">

                            <div class="col-md-offset-3 col-md-8">
                                <div class="checkbox">
                                    <label>
                                        <input name="show_in_footer" type="checkbox"> Show Category in Footer </label>
                                </div>
                            </div>

                        </div>

                        <div class="form-group">
                            <label for="seo_keywords" class="col-sm-3 control-label">SEO Keywords</label>

                            <div class="col-sm-8">
                                <textarea id="seo_keywords" class="form-control" name="seo_keywords"
                                          placeholder="Enter SEO Keywords">{{old('seo_keywords')}}</textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="seo_description" class="col-sm-3 control-label">SEO Description</label>

                            <div class="col-sm-8">
                                <textarea id="seo_description" class="form-control" name="seo_description"
                                          placeholder="Enter SEO Description">{{old('seo_description')}}</textarea>
                            </div>
                        </div>


                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i> Save</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- END PORTLET-->
        </div>
    </div>
@stop